namespace RVIWPF.Migrations
{
    using System;
    using System.Data.Entity.Migrations;
    
    public partial class InitialMigration : DbMigration
    {
        public override void Up()
        {
            CreateTable(
                "dbo.Cities",
                c => new
                    {
                        Id = c.Int(nullable: false, identity: true),
                        CityName = c.String(nullable: false),
                    })
                .PrimaryKey(t => t.Id);
            
            CreateTable(
                "dbo.Shifts",
                c => new
                    {
                        Id = c.Int(nullable: false, identity: true),
                        Date = c.DateTime(nullable: false),
                        ShiftValId = c.Int(nullable: false),
                        CityId = c.Int(nullable: false),
                        UserId = c.Int(nullable: false),
                        User1Id = c.Int(nullable: false),
                        User2Id = c.Int(nullable: false),
                        User3Id = c.Int(nullable: false),
                        AccountBalance = c.Double(nullable: false),
                    })
                .PrimaryKey(t => t.Id)
                .ForeignKey("dbo.ShiftValues", t => t.ShiftValId)
                .ForeignKey("dbo.Users", t => t.UserId)
                .ForeignKey("dbo.Users", t => t.User1Id)
                .ForeignKey("dbo.Users", t => t.User2Id)
                .ForeignKey("dbo.Users", t => t.User3Id)
                .ForeignKey("dbo.Cities", t => t.CityId)
                .Index(t => t.ShiftValId)
                .Index(t => t.CityId)
                .Index(t => t.UserId)
                .Index(t => t.User1Id)
                .Index(t => t.User2Id)
                .Index(t => t.User3Id);
            
            CreateTable(
                "dbo.ShiftValues",
                c => new
                    {
                        Id = c.Int(nullable: false, identity: true),
                        ShiftNumber = c.String(nullable: false),
                        ShiftVal = c.Double(nullable: false),
                    })
                .PrimaryKey(t => t.Id);
            
            CreateTable(
                "dbo.Users",
                c => new
                    {
                        Id = c.Int(nullable: false, identity: true),
                        CityId = c.Int(nullable: false),
                        Email = c.String(nullable: false),
                        PhoneNumber = c.Int(nullable: false),
                        UserName = c.String(nullable: false),
                        Surname = c.String(nullable: false),
                    })
                .PrimaryKey(t => t.Id)
                .ForeignKey("dbo.Cities", t => t.CityId)
                .Index(t => t.CityId);
            
            CreateTable(
                "dbo.DayValues",
                c => new
                    {
                        Id = c.Int(nullable: false, identity: true),
                        Monday = c.Double(nullable: false),
                        Tuesday = c.Double(nullable: false),
                        Wednesday = c.Double(nullable: false),
                        Thursday = c.Double(nullable: false),
                        Friday = c.Double(nullable: false),
                        Saturday = c.Double(nullable: false),
                        Sunday = c.Double(nullable: false),
                    })
                .PrimaryKey(t => t.Id);
            
        }
        
        public override void Down()
        {
            DropForeignKey("dbo.Users", "CityId", "dbo.Cities");
            DropForeignKey("dbo.Shifts", "CityId", "dbo.Cities");
            DropForeignKey("dbo.Shifts", "User3Id", "dbo.Users");
            DropForeignKey("dbo.Shifts", "User2Id", "dbo.Users");
            DropForeignKey("dbo.Shifts", "User1Id", "dbo.Users");
            DropForeignKey("dbo.Shifts", "UserId", "dbo.Users");
            DropForeignKey("dbo.Shifts", "ShiftValId", "dbo.ShiftValues");
            DropIndex("dbo.Users", new[] { "CityId" });
            DropIndex("dbo.Shifts", new[] { "User3Id" });
            DropIndex("dbo.Shifts", new[] { "User2Id" });
            DropIndex("dbo.Shifts", new[] { "User1Id" });
            DropIndex("dbo.Shifts", new[] { "UserId" });
            DropIndex("dbo.Shifts", new[] { "CityId" });
            DropIndex("dbo.Shifts", new[] { "ShiftValId" });
            DropTable("dbo.DayValues");
            DropTable("dbo.Users");
            DropTable("dbo.ShiftValues");
            DropTable("dbo.Shifts");
            DropTable("dbo.Cities");
        }
    }
}
